% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program shepard.m

%%% Program shepard.m
Judged_similarities = ...
[1.0 .86 .42 .42 .18 .06 .07 .04 .02 .07 .09 .12 .13 .16
 .86 1.0 .50 .44 .22 .09 .07 .07 .02 .04 .07 .11 .13 .14
 .42 .50 1.0 .81 .47 .17 .10 .08 .02 .01 .02 .01 .05 .03
 .42 .44 .81 1.0 .54 .25 .10 .09 .02 .01 .00 .01 .02 .04
 .18 .22 .47 .54 1.0 .61 .31 .26 .07 .02 .02 .01 .02 .00
 .06 .09 .17 .25 .61 1.0 .62 .45 .14 .08 .02 .02 .02 .01
 .07 .07 .10 .10 .31 .62 1.0 .73 .22 .14 .05 .02 .02 .00
 .04 .07 .08 .09 .26 .45 .73 1.0 .33 .19 .04 .03 .02 .02
 .02 .02 .02 .02 .07 .14 .22 .33 1.0 .58 .37 .27 .20 .23
 .07 .04 .01 .01 .02 .08 .14 .19 .58 1.0 .74 .50 .41 .28
 .09 .07 .02 .00 .02 .02 .05 .04 .37 .74 1.0 .76 .62 .55
 .12 .11 .01 .01 .01 .02 .02 .03 .27 .50 .76 1.0 .85 .68
 .13 .13 .05 .02 .02 .02 .02 .02 .20 .41 .62 .85 1.0 .76
 .16 .14 .03 .04 .00 .01 .00 .02 .23 .28 .55 .68 .76 1.0];
 
Wavelength = {'434' '445' '465' '472' '490' '504' '537' ...
     '555' '584' '600' '610' '628' '651' '674'};
Representation = mdscale(Judged_similarities, 2);
 
figure;
for i=1:14
    plot(Representation(i, 1), -Representation(i, 2),'kx');
    text(Representation(i,1),  -Representation(i,2), ...
         Wavelength(i));
    hold on;
end
plot([Representation(:, 1); Representation(1,1)], ...
    -[Representation(:,2); Representation(1, 2)], 'k-'); 
axis('square');
axis('off');
 
sdRelation = [];
for i = 1:14
    for j = 1:14
      Distance = sqrt(...
          (Representation(i, 1) - Representation(j, 1)).^2 ...
        + (Representation(i, 2) - Representation(j, 2)).^2);
      sdRelation = [sdRelation; Distance ...     
          Judged_similarities(i, j)];
    end
end

figure;
plot(sdRelation(:, 1), sdRelation(:, 2), 'ko');
axis('square');
xlabel('Obtained Euclidean distance','Fontsize', 24, ...
      'Fontname', 'Arial');
ylabel('Similarity between colors','Fontsize', 24, ...
      'Fontname', 'Arial');
